#
# C.O.R.E. Province Setup for v0.6 release
#  by Steel
#
#  This file contains all changes made to infra, ic, resources, manpower,
#  forts, coastal forts, anti-air and province resource stockpiles.
#
#  It does not contain any map changes such as location of port icons, 
#  adding beaches etc (these are still in province.csv).
#  



###  	Australia 1936 by A.B.Mathers

###	Fortifications already in place in 1936 and constantly improved upto 1939
###	Newcastle also had coastal forts, but since it has no beach, no point in placing.
###	After 1936 coastal forts improved in Darwin and Broome probably bringing 
###	them upto level 1 or more.  (Fortifications originally placed against Russian threat!)

province = { id = 2105 landfort = 0 coastalfort = 1 } #Brisbane
province = { id = 2075 landfort = 0 coastalfort = 1 } #Melbourne
province = { id = 2078 landfort = 0 coastalfort = 2 } #Sydney
province = { id = 2042 landfort = 0 coastalfort = 1 } #Perth

#Eben Emmel
province = {	id = 557	landfort = 2	}

# Czech

province = {	id = 613	landfort = 8	}
province = {	id = 578	landfort = 8	}
province = {	id = 616	landfort = 8	}
province = {	id = 617	landfort = 8	}


#Mannerheim line
province = {	id = 787	landfort = 2 }
province = {	id = 705	coastalfort = 1 }#Turkku
province = {	id = 706	coastalfort = 1 }#Helsinki


#Maginot line
province = {	id = 555	landfort = 10 }
province = {	id = 542	landfort = 10 }
province = {	id = 554	landfort = 10 }

#Germany
#Prussian resource stockpile
province = {  id = 646  oilpool = 500 supplypool = 2000 }

# Greece
province = {	id = 872	landfort = 1	} # was 5
province = {	id = 874	landfort = 1	} # was 5

# Italy
#Tobruk
province = {	id = 1097	landfort = 3 }
#Supply pools in Africa
province = {  id = 1285  oilpool = 500 supplypool = 5000 }
province = {  id = 1302  oilpool = 500 supplypool = 5000 }
province = {  id = 1087  oilpool = 1000 supplypool = 5000 }

# Japan
#Korea resource stockpile
province = {  id = 1676  oilpool = 1000 supplypool = 3000 }

# Norway
province = {	id = 664	landfort = 0 coastalfort = 3 }#Oslofjorden
province = {	id = 674	landfort = 0 coastalfort = 2 }#Trondheim/Agdenes
province = {	id = 671	landfort = 0  coastalfort = 3 } #Bergen

# Philippines
province = {	id = 1802	coastalfort = 1	} # Limited forts, was 5
province = {	id = 1804	coastalfort = 1	} # Limited forts
province = {	id = 1800	coastalfort = 1	} # Limited forts

# Soviet
province = {	id = 788	landfort = 5 coastalfort = 5 antiair = 3 }#Leningrad
province = {	id = 846	landfort = 5 coastalfort = 0 antiair = 3 }#Moscow
province = {	id = 1225	landfort = 5 coastalfort = 0 antiair = 1 }#Stalingrad
province = {	id = 862	landfort = 3 coastalfort = 5 }#Sevestapol
province = {	id = 1663	landfort = 1 coastalfort = 3 }#Vladivostok

# Sweden
province = {	id = 2160	landfort = 0 coastalfort = 3 }#Stockholms Kustartillerifrsvar
province = {	id = 682	landfort = 3 coastalfort = 0 }#Bodens Fstning
province = {	id = 654	landfort = 0 coastalfort = 3 }#Karlkrona Kustartillerifrsvar
province = {	id = 653	landfort = 0 coastalfort = 1 }#Marindistrikt resund
province = {	id = 660	landfort = 0 coastalfort = 3 }#lvsborgs Kustartillerifrsvar
province = {	id = 691	landfort = 1 coastalfort = 0 }#Karlsborgs Fstning

#Swiss defenses
province = {	id = 564	landfort = 3 }
province = {	id = 541	landfort = 3 }
province = {	id = 914	landfort = 3 }
province = {	id = 936	landfort = 3 }


# United Kingdom
# Forts
# Singapore removed to assist Japanese AI
province = {	id = 503	landfort = 0 coastalfort = 3 } #Dover
province = {	id = 1766	oilpool = 2000 supplypool = 2500 }  #Singapore
province = {	id = 1717	landfort = 3 coastalfort = 0 oilpool = 1000 supplypool = 1000 }  #Hong Kong
province = {	id = 1480	landfort = 0 coastalfort = 3 oilpool = 100 supplypool = 500 }   #Ceylon
province = {	id = 989	landfort = 6  coastalfort = 6 oilpool = 500 supplypool = 2500 } #Gibraltar
province = {	id = 896	landfort = 0  coastalfort = 5 oilpool = 1000 supplypool = 1000 } #Malta


#########################################################
#  Province resource changes
#########################################################

#Burma
province = {  id = 1580	coal = 15 }
province = {  id = 1588	ic = 2 maxic = 2  steel = 5 }
province = {  id = 1589	ic = 1 maxic = 1  rubber = 5 }
province = {  id = 1590	oil = 10  steel = 10 }
province = {  id = 1594	rubber = 5 }

#Ecuador
province = {  id = 292 manpower = 2 ic = 8 maxic = 8 infra = 0.30 maxinfra = 0.30 } # Quito
province = {  id = 291 manpower = 2 ic = 7 maxic = 7 infra = 0.40 maxinfra = 0.40 } # Guyaquil
province = {  id = 300 infra = 0.30 maxinfra = 0.30 } # Iquitos
# Port moved from Quito to Guyaquil in province.csv

#Karachi
# Port and beach added in province.csv, adj. seazone 1453.
#Abadan
# Port added in province.csv, adj. seazone 1351
#Bandar Abbas
# Port added in province.csv, adj. seazone 1416

#Egypt
province = { id = 1090 infra = 0.35 maxinfra = 0.35 } # Matruh
province = { id = 1091 infra = 0.35 maxinfra = 0.35 ic = 1 maxic = 1 } # Sidi Barrani
province = { id = 1092 infra = 0.35 maxinfra = 0.35 ic = 1 maxic = 1 manpower = 2 } # Bardiyah
province = { id = 1093 infra = 0.15 maxinfra = 0.15 manpower = 0 } # Al Quattara
province = { id = 1099 infra = 0.60 maxinfra = 0.60 steel = 6 manpower = 6 ic = 5 maxic = 5 } # Alexandria
province = { id = 1100 infra = 0.40 maxinfra = 0.50 steel = 3 manpower = 5 } # Port Said
province = { id = 1101 infra = 0.40 maxinfra = 0.50 steel = 14 ic = 13 maxic = 13 manpower = 8 } # Cairo
province = { id = 1102 infra = 0.40 maxinfra = 0.40 manpower = 1 ic = 1 maxic = 3 } # Suez
province = { id = 1103 infra = 0.35 maxinfra = 0.40 manpower = 3 coal = 10 } # Al Minyah. 
province = { id = 1104 infra = 0.15 maxinfra = 0.15 oil = 5 manpower = 0 } # Al Hariga
province = { id = 1200 infra = 0.35 maxinfra = 0.40 coal = 25 manpower = 4 ic = 1 maxic = 1 } # Assuan
province = { id = 1201 infra = 0.35 maxinfra = 0.35 coal = 9 manpower = 3 } # Sawhaj
province = { id = 1202 infra = 0.35 maxinfra = 0.35 oil = 8 ic = 1 maxic = 1 manpower = 2 } # Marsa El-Alam
province = { id = 1203 infra = 0.35 maxinfra = 0.40 coal = 6 manpower = 2 } # Al Qusiayah
province = { id = 1206 infra = 0.35 maxinfra = 0.35 coal = 3 oil = 15 manpower = 2 ic = 1 maxic = 1 } # El Arish

#Syria
province = { id = 1268 infra = 0.20 maxinfra = 0.20 oil = 6 manpower = 1 ic = 2 maxic = 2 } # Rawah
province = { id = 1269 infra = 0.50 maxinfra = 0.50 coal = 5 steel = 2 manpower = 4 ic = 2 maxic = 2 } # Aleppo
province = { id = 1270 infra = 0.30 maxinfra = 0.30 coal = 5 manpower = 3 ic = 1 maxic = 1 } # Homs
province = { id = 1274 infra = 0.35 maxinfra = 0.35 coal = 8 steel = 6 manpower = 5 ic = 4 maxic = 4 } # Damascus

#Lebanaon  
province = { id = 1273 infra = 0.35 maxinfra = 0.35 coal = 8 steel = 6 manpower = 5 ic = 4 maxic = 4 } # Beirut

#Saudi Arabia.  Removed ahistorical (?) coal/steel production and added world market trades.
province = { id = 1276 coal = 0 steel = 0 infra = 0.35 maxinfra = 0.35 }
province = { id = 1277 coal = 0 steel = 0 infra = 0.35 maxinfra = 0.35 }
province = { id = 1282 infra = 0.35 maxinfra = 0.35 } # Mecka (Saudi)
province = { id = 1349 infra = 0.35 maxinfra = 0.35 } # Az Zahran (Saudi

#Iraq.  Removed ahistorical (?) coal/steel production and added world market trades.
province = { id = 1267 coal = 0 steel = 0 } # Kirkuk
province = { id = 1272 coal = 0 steel = 0 } # Bagdad
province = { id = 1271 coal = 0 steel = 0 } # Mosul

#Switzerland.  Swiss economy is negative in all resources.
province = { id = 541 steel = 50 } # Bern

#Norway.  Steel production represents income from Swedish transit shipments (needed for coal/rubber buys)
province = { id = 680 steel = 80 } # Narvik. Paradox value is 160.

#Sweden.  Sweden is a major exporter of steel via Norway and Baltic ports.
province = { id = 681 steel = 230 } # Gallivare. Paradox value is 200. 50 iron put in Switzerland.

#Holland
# Supply pools
province = { id = 1780 oilpool = 100 supplypool = 100 }
province = { id = 1774 oilpool = 100 supplypool = 100 }
province = { id = 311 oilpool = 100 supplypool = 100 }
province = { id = 283 oilpool = 100 supplypool = 100 }

# East Indies
province = { id = 1756 ic = 0 maxic = 0 } # Sinabang
province = { id = 1757 ic = 0 maxic = 0 } # Lahewa
province = { id = 1767 ic = 0 maxic = 0 } # Dumai
province = { id = 1771 ic = 0 maxic = 0 } # Silagui
province = { id = 1772 ic = 0 maxic = 0 } # Sipora
province = { id = 1785 ic = 0 maxic = 0 } # Pontianak
province = { id = 1952 ic = 0 maxic = 0 } # Raba
province = { id = 1954 ic = 0 maxic = 0 } # Besar
province = { id = 1955 ic = 0 maxic = 0 } # Mataram
province = { id = 1970 ic = 0 maxic = 0 } # Palu
province = { id = 2012 ic = 0 maxic = 0 } # Namlea
province = { id = 2028 ic = 0 maxic = 0 } # Ende
province = { id = 2029 ic = 0 maxic = 0 } # Memboro
province = { id = 2030 ic = 0 maxic = 0 } # Baubau
province = { id = 1779 ic = 3 maxic = 3 } # Yogyakarta
province = { id = 1780 ic = 6 maxic = 6 } # Batavia
province = { id = 1950 ic = 6 maxic = 6 } # Surabaya
province = { id = 1951 ic = 3 maxic = 3 } # Banjuwangi

#UK
#Supply pools 
province = {  id = 1459	oilpool = 1000 supplypool = 2000 } # India (Bombay)
province = {  id = 989  oilpool = 100  supplypool = 500 } # Gibraltar
province = {  id = 896  oilpool = 100  supplypool = 500 } # Valetta(Malta)
province = {  id = 1717	oilpool = 100  supplypool = 500 } # Hong Kong
province = {  id = 1480	oilpool = 100  supplypool = 500 } # Colombo
province = {  id = 1766	oilpool = 100  supplypool = 500 } # Singapore
province = {  id = 222	oilpool = 100  supplypool = 500 } # Bermuda Islands
province = {  id = 1042	oilpool = 100  supplypool = 500 } # FreeTown
#UK colonial areas in Africa
province = { id = 1195 infra = 0.35 maxinfra = 0.35 } #Khartoum (UK) #1195 (base 09) 
province = { id = 1196 infra = 0.35 maxinfra = 0.35 } #Omdurman (UK) #1196 (base 09)
province = { id = 1199 infra = 0.35 maxinfra = 0.35 } #Kassala (UK) #1199 (base 09)
province = { id = 1146 infra = 0.35 maxinfra = 0.35 } #Lusaka (UK) #1146 (base 09)
province = { id = 1180 infra = 0.35 maxinfra = 0.35 } #Bulawayo (UK) #1180 (base 09)
province = { id = 1163 infra = 0.35 maxinfra = 0.35 } #Gaberones (UK) #1163 (base 09)

#Portugal
province = { id = 1999 infra = 0.35 maxinfra = 0.35 } #Tete (POR) #1999 (base 09)

#Belgium
province = { id = 1186 infra = 0.35 maxinfra = 0.35 } #Bakwanga (BEL) #1186 (base 09)
province = { id = 1129 infra = 0.35 maxinfra = 0.35 } #Coquilhatville (BEL) #1129 (base 00)

#ComChi 
province = { id = 1570 ic = 2 maxic = 2 rubber = 0 oil = 0 infra = 0.33 maxinfra = 0.33 }
province = { id = 1571 ic = 3 maxic = 3 rubber = 0 oil = 0 infra = 0.33 maxinfra = 0.33 }

#China
province = { id = 1572 infra = 0.33 maxinfra = 0.33 }
province = { id = 1612 infra = 0.33 maxinfra = 0.33 } # Wutunghliao
province = { id = 1614 infra = 0.33 maxinfra = 0.33 } # Guiyuan
province = { id = 1606 infra = 0.33 maxinfra = 0.33 } # Kaiyuan
province = { id = 1602 infra = 0.33 maxinfra = 0.33 } # Mojian
province = { id = 1601 infra = 0.33 maxinfra = 0.33 } # Baoshan


# Japan, revised total 220 versus default of 135
province = { id = 1682 ic = 25 maxic = 20 } # Hiroshima
province = { id = 1825 ic = 25 maxic = 20 } # Osaka 
province = { id = 1824 ic = 20 maxic = 20 } # Kanazawa
province = { id = 1823 ic = 25 maxic = 20 } # Nagoya
province = { id = 1821 ic = 20 maxic = 20 } # Niigata
province = { id = 1822 ic = 40 maxic = 30 } # Tokyo
province = { id = 1820 ic = 20 maxic = 20 } # Fukushima
province = { id = 1818 ic = 20 maxic = 20 } # Akita
province = { id = 1819 ic = 20 maxic = 20 } # Senda
province = { id = 1684 ic = 15 maxic = 15 } # Fukuoka
province = { id = 1681 ic = 20 maxic = 15 } # Kagoshima

#Argentina
province = { id = 365 infra = 0.40 maxinfra = 0.40 ic = 4 maxic = 4 manpower = 3 } #Resistencia
province = { id = 369 infra = 0.35 maxinfra = 0.35 terrain = "marsh" ic = 2 maxic = 2 manpower = 1 rubber = 5 } #Corrientes
province = { id = 370 ic = 10 maxic = 10 manpower = 4 } #Santa Fe
province = { id = 373 infra = 0.35 maxinfra = 0.35 manpower = 2 } #San Miguel de Tucuman  climate = "mediterranean" 
province = { id = 374 terrain = "hills" infra = 0.60 maxinfra = 0.60 ic = 12 maxic = 12 } #Cordoba (add enough Victory Points for red star in the VP file)
province = { id = 380 infra = 0.40 maxinfra = 0.40 ic = 2 maxic = 2 manpower = 1 } #Mendoza (add enough Victory Points for red star in the VP file ???)
province = { id = 383 ic = 0 maxic = 0 } #General Roca
province = { id = 384 } #Buenos Aires No changes
province = { id = 385 infra = 0.60 maxinfra = 0.60 } #Mar del Plata
province = { id = 386 infra = 0.60 maxinfra = 0.60 } #Bahia Blanca
province = { id = 391 terrain = "desert" } #Trelew
province = { id = 392 infra = 0.30 maxinfra = 0.30 } #Junin de los Andes
province = { id = 396 terrain = "desert" Oil = 6 } #Comodoro Rivadavia
province = { id = 398 terrain = "desert" infra = 0.30 maxinfra = 0.35 coal = 20 } #San Julian  climate = "Subartic" 
province = { id = 401 ic = 0 maxic = 0 } #Lago Posadas
province = { id = 410 terrain = "hills" infra = 0.20 maxinfra = 0.20 ic = 0 maxic = 0 coal = 5 } # San Sebastian

#Persia
province = { id = 1358 infra = 0.45 maxinfra = 0.45 } #Tabriz 35----->45
province = { id = 1361 infra = 0.40 maxinfra = 0.40 } #Rasht 20----->40
province = { id = 1412 infra = 0.40 maxinfra = 0.40 } #Gorgan 20----->40
province = { id = 1410 infra = 0.35 maxinfra = 0.35 } #Mashhad 20----->35
province = { id = 1364 infra = 0.50 maxinfra = 0.50 } #Teheran 50----->50
province = { id = 1362 infra = 0.40 maxinfra = 0.40 } #Hamadan 20----->40
province = { id = 1363 infra = 0.40 maxinfra = 0.40 } #Qahremanshahr 35---->40
province = { id = 1357 infra = 0.40 maxinfra = 0.40 } #Esfahan 35----->40
province = { id = 1356 infra = 0.50 maxinfra = 0.50 } #Abadan 35----->50
province = { id = 1350 infra = 0.40 maxinfra = 0.40 } #Shiraz 35----->40
province = { id = 1413 infra = 0.35 maxinfra = 0.35 } #Kerman 35----->35
province = { id = 1414 infra = 0.40 maxinfra = 0.40 } #Bandar Abbas 60----->40 
province = { id = 1411 infra = 0.30 maxinfra = 0.40 } #Jandaq 20----->40
province = { id = 1406 infra = 0.25 maxinfra = 0.25 } #Yazd 20----->25
province = { id = 1407 infra = 0.25 maxinfra = 0.25 } #Birjand 20------>25

#USSR 
province = { id = 1530 coal = 20 steel = 20 } # Norilsk
province = { id = 1397 coal = 47 } # Akmolinsk 
province = { id = 1250 coal = 30 } # Uralsk
province = { id = 1855 coal = 60 } # Kamenskoje
province = { id = 1375 coal = 20 steel = 10 } # Nizjnij Tagil
province = { id = 1371 coal = 10 steel = 20 } # Magnitogorsk
province = { id = 1436 steel = 20 } # Stalinabad
province = { id = 1431 steel = 20 } # Frunze
province = { id = 1380 coal = 65 } # Vorkuta
province = { id = 792 steel = 10 } # Tichvin

#Sweden
province = {  id = 675	ic = 1 maxic = 1 }

#Yugoslavia
province = { id = 740 infra = 0.40 maxinfra = 0.40 } #Osijek
province = { id = 741 infra = 0.40 maxinfra = 0.40 } #Novi Sad
province = { id = 745 infra = 0.50 maxinfra = 0.50 coal = 50 steel = 25 rubber = 30 ic = 5 maxic = 5 terrain = "hills" } # Sarajevo
province = { id = 746 terrain = "hills" }

#Afghanistan
province = {  id = 1437	ic = 3 maxic = 3 }
province = {  id = 1419	ic = 2 maxic = 2 }


#################### 1.05c changes ##########################
#Argentina
province = { id = 384   antiair = 2 } #Buenos Aires
province = { id = 369   antiair = 1 } #Corrientes
province = { id = 417   antiair = 1 } #Cordoba
#Australia
province = { id = 2095   antiair = 3 } #Darwin
province = { id = 2105   antiair = 1 } #Brisbane
province = { id = 2078   antiair = 3 } #Sydney
province = { id = 2076   antiair = 2 } #Canberra
province = { id = 2075   antiair = 3 } #Melbourne
province = { id = 2066   antiair = 2 } #Adelaide
province = { id = 2067   antiair = 1 } #Port Augusta
province = { id = 2042   antiair = 2 } #Perth
province = { id = 2003   antiair = 3 } #Port Moresby
province = { id = 2023   antiair = 1 } #Lae
province = { id = 2025   antiair = 2 } #New Britain
province = { id = 1966   antiair = 3 } #North Solomon Islands
#Austria
province = { id = 621   antiair = 2 } #Wien
province = { id = 610   antiair = 1 } #Salzburg
province = { id = 623   antiair = 1 } #Graz
#Belgium
province = { id = 557   antiair = 2 } #Arlon (Eben-Emael)
province = { id = 552   antiair = 1 } #Bruxelles
province = { id = 548   antiair = 2 } #Antwerpen
#Brazil
province = { id = 351   antiair = 2 } #Belo Horizonte
province = { id = 360   antiair = 2 } #Sao Paulo
province = { id = 356   antiair = 2 } #Rio de Janeiro
province = { id = 358   antiair = 1 } #Santos
#Canada
province = { id = 750   antiair = 2 } #Sofia
province = { id = 809   antiair = 1 } #Varna
province = { id = 128   antiair = 2 } #Ottawa
province = { id = 149   antiair = 1 } #Montral
province = { id = 154   antiair = 2 } #Qubec
province = { id = 2199  antiair = 1 } #Toronto
province = { id = 4     antiair = 1 } #Vancouver
#Colombia
province = { id = 281   antiair = 1 } #Cartagena
province = { id = 284   antiair = 2 } #Bogota
#Czechoslovakia
province = { id = 612   antiair = 2 } #Plzen
province = { id = 615   antiair = 3 } #Praha
province = { id = 619   antiair = 2 } #Slavkov/Brno
province = { id = 618   antiair = 1 } #Bratislava
#Denmark
province = { id = 594   antiair = 2 } #Kobenhavn
#Finland
province = { id = 706   antiair = 3 } #Helsinki
province = { id = 787   antiair = 2 } #Viipuri
province = { id = 803   antiair = 2 } #Sortalava
province = { id = 705   antiair = 1 } #Turku
province = { id = 702   antiair = 2 } #Mariehamm
#France
province = { id = 518   antiair = 1 } #Lille
province = { id = 520   antiair = 1 } #Sedan
province = { id = 527   antiair = 3 } #Paris
province = { id = 915   antiair = 1 } #Vichy
province = { id = 538   antiair = 2 } #Brest
province = { id = 536   antiair = 2 } #Nantes
province = { id = 948   antiair = 2 } #Bordeaux
province = { id = 929   antiair = 3 } #Marseille
province = { id = 543   antiair = 2 } #Nancy
province = { id = 556   antiair = 1 } #Chaumont
province = { id = 1081  antiair = 2 } #Tunis
province = { id = 1077  antiair = 2 } #Algiers
province = { id = 1011  antiair = 1 } #Casablanca
province = { id = 1033  antiair = 1 } #Dakar
province = { id = 1607  antiair = 2 } #Hanoi
province = { id = 1733  antiair = 1 } #Saigon
province = { id = 531   antiair = 1 } #Caen
province = { id = 532   antiair = 1 } #Cherbourg
#Germany
province = { id = 558   antiair = 2 } #Kln
province = { id = 559   antiair = 2 } #Essen
province = { id = 585   antiair = 2 } #Magdeburg
province = { id = 560   antiair = 2 } #Saarbrcken
province = { id = 1961   antiair = 2 } #Frankfurt-am-Main
province = { id = 575   antiair = 2 } #Mannheim
province = { id = 577   antiair = 1 } #Stuttgart
province = { id = 562   antiair = 1 } #Mnchen
province = { id = 574   antiair = 1 } #Nrnberg
province = { id = 589   antiair = 1 } #Wilhelmshafen
province = { id = 588   antiair = 2 } #Hamburg
province = { id = 586   antiair = 2 } #Kiel
province = { id = 587   antiair = 1 } #Lbeck
province = { id = 602   antiair = 2 } #Berlin
province = { id = 605   antiair = 1 } #Leipzig
province = { id = 650   antiair = 1 } #Knigsberg
#Greece
province = { id = 891   antiair = 2 } #Athinai
province = { id = 872   antiair = 2 } #Thessaloniki
#Holland
province = { id = 550   antiair = 2 } #Amsterdam
province = { id = 551   antiair = 2 } #Eindhoven
#Hungary
province = { id = 633   antiair = 2 } #Budapest
#Iraq
province = { id = 1272   antiair = 3 } #Bagdad
province = { id = 1271   antiair = 1 } #Mosul
#Italy
province = { id = 932   antiair = 3 } #Torino
province = { id = 933   antiair = 2 } #Genoa
province = { id = 912   antiair = 3 } #Milano
province = { id = 913   antiair = 2 } #La Spezia
province = { id = 567   antiair = 1 } #Venezia
province = { id = 910   antiair = 1 } #Parma
province = { id = 905   antiair = 1 } #Bologna
province = { id = 906   antiair = 1 } #Firenze
province = { id = 908   antiair = 3 } #Roma
province = { id = 901   antiair = 2 } #Napoli
province = { id = 893   antiair = 2 } #Taranto
province = { id = 897   antiair = 1 } #Messina
province = { id = 1085  antiair = 1 } #Tripoli
province = { id = 1097  antiair = 1 } #Tobruk
province = { id = 1098  antiair = 1 } #Benghazi
#Japan
province = { id = 1674   antiair = 2 } #Keijo
province = { id = 1561   antiair = 1 } #Dalian
province = { id = 1822   antiair = 4 } #Tokyo
province = { id = 1820   antiair = 2 } #Fukushima
province = { id = 1821   antiair = 2 } #Niigata
province = { id = 1819   antiair = 2 } #Sendai
province = { id = 1823   antiair = 3 } #Nagoya
province = { id = 1825   antiair = 4 } #Osaka
province = { id = 1716   antiair = 2 } #Taihoku
province = { id = 1812   antiair = 2 } #Bonin Islands
province = { id = 1937   antiair = 3 } #Mariane Islands
province = { id = 2002   antiair = 3 } #Caroline Islands
province = { id = 2035   antiair = 2 } #Truk Islands
province = { id = 1919   antiair = 3 } #Kwajalein
province = { id = 1899   antiair = 2 } #Eniwetok
province = { id = 1923   antiair = 3 } #Marshall Islands
#Mexico
province = { id = 244   antiair = 2 } #Ciudad de Mxico
province = { id = 237   antiair = 1 } #Monterey
province = { id = 242   antiair = 1 } #Guadalajara
#Norway
province = { id = 664   antiair = 2 } #Oslo
province = { id = 671   antiair = 1 } #Bergen
province = { id = 680   antiair = 2 } #Narvik
#Poland
province = { id = 606   antiair = 2 } #Poznan
province = { id = 645   antiair = 2 } #Danzig
province = { id = 639   antiair = 2 } #Lodz
province = { id = 638   antiair = 2 } #Krakow
province = { id = 643   antiair = 3 } #Warszawa
province = { id = 725   antiair = 2 } #Lwow
#Portugal
province = { id = 964   antiair = 1 } #Porto
province = { id = 975   antiair = 2 } #Lissabon
#Romania
province = { id = 763   antiair = 1 } #Chisinau
province = { id = 761   antiair = 2 } #Constanta
province = { id = 760   antiair = 3 } #Ploiesti
province = { id = 757   antiair = 3 } #Bucuresti
#South Africa
province = { id = 1175   antiair = 3 } #Johannesburg
province = { id = 1172   antiair = 1 } #Durban
province = { id = 1167   antiair = 1 } #Port Elizabeth
province = { id = 1156   antiair = 2 } #Cape Town
#USSR
province = { id = 791   antiair = 1 } #Novgorod
province = { id = 822   antiair = 2 } #Murmansk
province = { id = 839   antiair = 2 } #Archangelsk
province = { id = 784   antiair = 2 } #Vitebsk
province = { id = 781   antiair = 3 } #Smolensk
province = { id = 778   antiair = 3 } #Minsk
province = { id = 779   antiair = 2 } #Mogiljov
province = { id = 856   antiair = 2 } #Bryansk
province = { id = 852   antiair = 1 } #Kaluga
province = { id = 772   antiair = 1 } #Bobrujsk
province = { id = 776   antiair = 2 } #Chernigov
province = { id = 775   antiair = 3 } #Kiev
province = { id = 764   antiair = 3 } #Odessa
province = { id = 865   antiair = 2 } #Dnepropetrovsk
province = { id = 862   antiair = 3 } #Sevastopol
province = { id = 857   antiair = 1 } #Kharkov
province = { id = 861   antiair = 2 } #Rostov
province = { id = 1227  antiair = 1 } #Voronezh
province = { id = 847   antiair = 2 } #Vladimir
province = { id = 850   antiair = 2 } #Nizjnij Novgorod
province = { id = 1220  antiair = 1 } #Batumi
province = { id = 1266  antiair = 1 } #Jerevan
province = { id = 1359  antiair = 3 } #Baku
province = { id = 1373  antiair = 3 } #Kujbysjev
province = { id = 1371  antiair = 3 } #Magnitogorsk
province = { id = 1663  antiair = 3 } #Vladivostok
#Spain
province = { id = 988   antiair = 2 } #Sevilla
province = { id = 972   antiair = 3 } #Madrid
province = { id = 957   antiair = 2 } #Burgos
province = { id = 956   antiair = 2 } #Gijon
province = { id = 969   antiair = 2 } #Barcelona
province = { id = 981   antiair = 2 } #Valencia
province = { id = 1009  antiair = 1 } #Ceuta
#Sweden
province = { id = 653   antiair = 1 } #Malm
province = { id = 660   antiair = 2 } #Gteborg
province = { id = 2160  antiair = 3 } #Stockholm
#Switzerland
province = { id = 541   antiair = 3 } #Bern
province = { id = 561   antiair = 3 } #Zrich
province = { id = 914   antiair = 3 } #Lausanne
province = { id = 936   antiair = 3 } #Genve
#UK
province = { id = 499   antiair = 3 } #London
province = { id = 498   antiair = 2 } #Coventry
province = { id = 503   antiair = 2 } #Portsmouth
province = { id = 502   antiair = 2 } #Southampton
province = { id = 501   antiair = 2 } #Plymouth
province = { id = 497   antiair = 2 } #Birmingham
province = { id = 489   antiair = 2 } #Manchester
province = { id = 486   antiair = 1 } #Glasgow
province = { id = 989   antiair = 2 } #Gibraltar
province = { id = 1099  antiair = 2 } #Alexandria
province = { id = 1100  antiair = 2 } #Port Said
province = { id = 1101  antiair = 2 } #Cairo
province = { id = 1102  antiair = 2 } #Suez
province = { id = 1205  antiair = 1 } #Jeruzalem
province = { id = 1717  antiair = 2 } #Hong Kong
province = { id = 1766  antiair = 2 } #Singapore
province = { id = 1590  antiair = 1 } #Rangoon
province = { id = 1490  antiair = 1 } #Calcutta
province = { id = 1446  antiair = 1 } #Delhi
#USA
province = { id = 181   antiair = 3 } #Norfolk
province = { id = 178   antiair = 3 } #Washington DC
province = { id = 177   antiair = 2 } #Philadelphia
province = { id = 124   antiair = 3 } #New York
province = { id = 125   antiair = 2 } #Boston
province = { id = 187   antiair = 2 } #Chicago
province = { id = 92    antiair = 2 } #Los Angeles
province = { id = 158   antiair = 2 } #San Francisco
province = { id = 22    antiair = 2 } #Honolulu
province = { id = 288   antiair = 2 } #Coln
province = { id = 1889  antiair = 2 } #Wake
province = { id = 1942  antiair = 2 } #Guam
#Venezuela
province = { id = 282   antiair = 1 } #Maracaibo
province = { id = 237   antiair = 2 } #Caracas
#Yugoslavia
province = { id = 624   antiair = 2 } #Zagreb
province = { id = 740   antiair = 1 } #Osijek
province = { id = 738   antiair = 2 } #Beograd
province = { id = 743   antiair = 1 } #Split
province = { id = 747   antiair = 2 } #Dubrovnik

################ Manpower Changes: Peacetime Unmobilized Nations ################

#### Albania
province = { id = 754    manpower = 0 } # Tirana
province = { id = 820    manpower = 0 } # Vlore
#### Argentina
province = { id = 384    manpower = 4 } #Buenos Aries
province = { id = 374    manpower = 2 } #Cordoba
province = { id = 370    manpower = 1 } #Santa Fe
province = { id = 365    manpower = 1 } #Resistencia
province = { id = 385    manpower = 1 } #Mar del Plato
province = { id = 386    manpower = 1 } #Bahia Blanca
province = { id = 373    manpower = 0 } #San Miguel
province = { id = 380    manpower = 0 } #Mendoza
province = { id = 369    manpower = 0 } #Corrientes
#### Australia
province = { id = 2078   manpower = 0 } #Sydney
province = { id = 2067   manpower = 0 } #Port Agusta
province = { id = 2042   manpower = 0 } #Perth
province = { id = 2075   manpower = 0 } #Melbourne
province = { id = 2076   manpower = 1 } #Canberra
province = { id = 2105   manpower = 0 } #Brisbane
province = { id = 2066   manpower = 0 } #Adelaide
province = { id = 2077   manpower = 0 } #Wagga Wagga
province = { id = 2025   manpower = 0 } #New Britain
province = { id = 2095   manpower = 0 } #Darwin
province = { id = 2101   manpower = 0 } #Cairns
#### Austria
province = { id = 621    manpower = 1 } #Wien
province = { id = 610    manpower = 0 } #Salzburg
province = { id = 611    manpower = 0 } #Linz
province = { id = 571    manpower = 0 } #Klagenfurt
province = { id = 623    manpower = 0 } #Graz
province = { id = 565    manpower = 0 } #Bregenz
province = { id = 573    manpower = 0 } #Innsbruck
province = { id = 620    manpower = 0 } #Horn
#### Belgium
province = { id = 552    manpower = 1 } #Bruxelles
province = { id = 548    manpower = 0 } #Antwerpen
province = { id = 557    manpower = 0 } #Arlon
#### Beruit
province = { id = 1273   manpower = 1 } #Beruit
#### Bolivia
province = { id = 343    manpower = 1 } #La Paz
province = { id = 348    manpower = 0 } #Santa Cruz
#### Brazil
province = { id = 356    manpower = 1 } #Rio de Janerio
province = { id = 318    manpower = 1 } #Recife
province = { id = 310    manpower = 1 } #Boa Vista
province = { id = 358    manpower = 1 } #Santos
province = { id = 327    manpower = 1 } #Santarem
province = { id = 354    manpower = 1 } #Salvador
province = { id = 326    manpower = 1 } #Maraba
province = { id = 323    manpower = 1 } #Forteleza
province = { id = 322    manpower = 1 } #Belem
province = { id = 351    manpower = 1 } #Belo Horizonte
province = { id = 355    manpower = 0 } #Vitoria
province = { id = 321    manpower = 0 } #Marajo
province = { id = 367    manpower = 0 } #Porto Alegre
province = { id = 359    manpower = 0 } #Curitiba
province = { id = 352    manpower = 0 } #Caiaba
province = { id = 362    manpower = 0 } #Campo Grande
#### Bulgaria
province = { id = 750    manpower = 3 } #Sofia
province = { id = 869    manpower = 2 } #Varna
province = { id = 871    manpower = 0 } #Plovdiv
province = { id = 756    manpower = 0 } #Ruse
#### Canada
province = { id = 2199   manpower = 0 } #Toronto
province = { id = 99     manpower = 0 } #Prince Rupert
province = { id = 128    manpower = 1 } #Ottawa
province = { id = 136    manpower = 0 } #Winnipeg
province = { id = 100    manpower = 0 } #Victoria (CAN)
province = { id = 149    manpower = 0 } #Montreal
province = { id = 153    manpower = 0 } #Halifax
province = { id = 148    manpower = 0 } #Gaspe
province = { id = 107    manpower = 0 } #Calgary
province = { id = 154    manpower = 0 } #Quebec
province = { id = 108    manpower = 0 } #Regina
province = { id = 137    manpower = 0 } #Sudbury
#### Chile
province = { id = 372    manpower = 1 } #Santiago
province = { id = 342    manpower = 0 } #Antofagasta
#### Columbia
province = { id = 297    manpower = 1 } #Medellin
province = { id = 996    manpower = 0 } #Cartagena
province = { id = 284    manpower = 0 } #Bogota
province = { id = 289    manpower = 0 } #Cali
#### Cuba
province = { id = 229    manpower = 1 } #La Habana
province = { id = 259    manpower = 0 } #Camaguey
#### Czechoslovakia
province = { id = 615    manpower = 1 } #Praha
province = { id = 618    manpower = 0 } #Bratislava
province = { id = 612    manpower = 0 } #Plzen
province = { id = 616    manpower = 0 } #Neuhaus
province = { id = 617    manpower = 0 } #Winterberg
province = { id = 614    manpower = 0 } #Troppau
province = { id = 619    manpower = 0 } #Slavkov
province = { id = 631    manpower = 0 } #Ruzomberok
province = { id = 613    manpower = 0 } #Richenberg
province = { id = 632    manpower = 0 } #Lucenec
province = { id = 578    manpower = 0 } #Karlsbad
province = { id = 727    manpower = 0 } #Kosice
province = { id = 726    manpower = 0 } #Munkacs
#### Denmark
province = { id = 594    manpower = 1 } #Koeberhavn
province = { id = 655    manpower = 0 } #Aarhus
province = { id = 595    manpower = 0 } #Kolding
province = { id = 596    manpower = 0 } #Odense
#### Ecuador
province = { id = 300    manpower = 1 } #Iquitos
province = { id = 292    manpower = 0 } #Quito
province = { id = 291    manpower = 0 } #Guayaquil
#### Egypt
province = { id = 1101    manpower = 2 } #Cairo
province = { id = 1099    manpower = 1 } #Alexandria
province = { id = 1100    manpower = 1 } #Port Said
province = { id = 1200    manpower = 1 } #Assuan
province = { id = 1201    manpower = 1 } #Sawhaj
province = { id = 1103    manpower = 1 } #Al Minyah
province = { id = 1202    manpower = 1 } #Marsa El-Alam
province = { id = 1206    manpower = 1 } #El Arish
province = { id = 1203    manpower = 1 } #Al Qusiyah
#### Estonia
province = { id = 707    manpower = 5 } #Tallinn
#### Finland
province = { id = 706    manpower = 3 } #Helsinki
province = { id = 705    manpower = 2 } #Turku
province = { id = 787    manpower = 0 } #Viipuri
province = { id = 801    manpower = 0 } #Tampere
province = { id = 799    manpower = 0 } #Seinajoki
province = { id = 813    manpower = 0 } #Oulu
#### France
province = { id = 527    manpower = 3 } #Paris
province = { id = 929    manpower = 2 } #Marseilles
province = { id = 915    manpower = 2 } #Vichy
province = { id = 1607   manpower = 2 } #Hanoi
province = { id = 931    manpower = 2 } #Gernoble
province = { id = 948    manpower = 2 } #Bordeaux
province = { id = 525    manpower = 1 } #Troyes
province = { id = 944    manpower = 1 } #Toulouse
province = { id = 930    manpower = 1 } #Toulon
province = { id = 555    manpower = 1 } #Strasbourg
province = { id = 520    manpower = 1 } #Sedan
province = { id = 545    manpower = 1 } #Saint Etienne
province = { id = 522    manpower = 1 } #Rouen
province = { id = 533    manpower = 1 } #Rennes
province = { id = 918    manpower = 1 } #Poitiers
province = { id = 947    manpower = 1 } #Perigueux
province = { id = 526    manpower = 0 } #Orleans
province = { id = 536    manpower = 0 } #Nantes
province = { id = 543    manpower = 0 } #Nancy
province = { id = 945    manpower = 0 } #Montpellier
province = { id = 554    manpower = 0 } #Metz
province = { id = 928    manpower = 0 } #Lyon
province = { id = 923    manpower = 0 } #Limoges
province = { id = 518    manpower = 0 } #Lille
province = { id = 534    manpower = 0 } #Le Mans
province = { id = 922    manpower = 0 } #La Rochelle
province = { id = 544    manpower = 0 } #Dijon
province = { id = 919    manpower = 0 } #d'Ousseant
province = { id = 542    manpower = 0 } #Colmar
province = { id = 934    manpower = 0 } #Clermont-Ferrand
province = { id = 917    manpower = 0 } #Chateauroux
province = { id = 535    manpower = 0 } #Cholet
province = { id = 556    manpower = 0 } #Chaumont
province = { id = 523    manpower = 0 } #Bourges
province = { id = 935    manpower = 0 } #Besancon
province = { id = 950    manpower = 0 } #Bayonne
province = { id = 937    manpower = 0 } #Bastia
province = { id = 524    manpower = 0 } #Auxerre
province = { id = 528    manpower = 0 } #Amiens
province = { id = 951    manpower = 0 } #Tarbes
province = { id = 926    manpower = 0 } #Rodez
province = { id = 927    manpower = 0 } #Nimes
province = { id = 539    manpower = 0 } #Lorient
province = { id = 538    manpower = 0 } #Brest
province = { id = 949    manpower = 0 } #Auch
province = { id = 537    manpower = 0 } #Saint-Malo
province = { id = 1733   manpower = 0 } #Saigon
province = { id = 1608   manpower = 0 } #Haiphong
province = { id = 1012   manpower = 0 } #Fez
province = { id = 1033   manpower = 0 } #Dakar
province = { id = 532    manpower = 0 } #Cherbourg
province = { id = 1011   manpower = 0 } #Casablanca
province = { id = 531    manpower = 0 } #Caen
province = { id = 529    manpower = 0 } #Reims
#### Greece
province = { id = 891    manpower = 4 } # Athinai
province = { id = 872    manpower = 2 } # Thessaloniki
province = { id = 890    manpower = 1 } # Patrai
province = { id = 875    manpower = 1 } # Larisa
province = { id = 874    manpower = 1 } # Ioannina
province = { id = 889    manpower = 1 } # Agrinion
province = { id = 887    manpower = 0 } # Iraklion
#### Holland
province = { id = 550    manpower = 1 } #Amsterdam
province = { id = 590    manpower = 0 } #Groningen
province = { id = 551    manpower = 0 } #Eindhoven
province = { id = 561    manpower = 0 } #Arnheim
province = { id = 1780   manpower = 0 } #Batavia
province = { id = 1773   manpower = 0 } #Palembang
province = { id = 1950   manpower = 0 } #Surabaya
province = { id = 1760   manpower = 0 } #Medan
province = { id = 1968   manpower = 0 } #Makassar
province = { id = 1779   manpower = 0 } #Yogyakarta
province = { id = 1774   manpower = 0 } #Oosthaven
province = { id = 283    manpower = 0 } #Curaco
province = { id = 1951   manpower = 0 } #Banjuwangi
province = { id = 2010   manpower = 0 } #The Molucks
province = { id = 1970   manpower = 0 } #Palu
province = { id = 1768   manpower = 0 } #Padang
province = { id = 1971   manpower = 0 } #Manado
province = { id = 1767   manpower = 0 } #Dumai
province = { id = 1794   manpower = 0 } #Banjarmasin
#### Hungary
province = { id = 633    manpower = 1 } #Budapest
province = { id = 622    manpower = 0 } #Szombathely
province = { id = 627    manpower = 0 } #Szeged
province = { id = 630    manpower = 0 } #Debrecen
province = { id = 626    manpower = 0 } #Pecs
province = { id = 634    manpower = 0 } #Veszprem
#### Iraq
province = { id = 1272   manpower = 2 } #Baghdad
province = { id = 1355   manpower = 1 } #Basrah
province = { id = 1271   manpower = 1 } #Mosul
province = { id = 1267   manpower = 1 } #Kirkuk
#### Ireland
province = { id = 495    manpower = 3 } #Dublin
province = { id = 496    manpower = 1 } #Cork
province = { id = 494    manpower = 1 } #Limerick
province = { id = 492    manpower = 0 } #Galway
#### Italy
province = { id = 908    manpower = 3 } #Roma
province = { id = 901    manpower = 2 } #Napoli
province = { id = 912    manpower = 2 } #Milano
province = { id = 932    manpower = 2 } #Torino
province = { id = 893    manpower = 2 } #Taranto
province = { id = 910    manpower = 2 } #Parma
province = { id = 906    manpower = 2 } #Frienze
province = { id = 905    manpower = 1 } #Bologna
province = { id = 913    manpower = 1 } #La Spezia
province = { id = 933    manpower = 1 } #Genoa
province = { id = 567    manpower = 0 } #Venezia
province = { id = 938    manpower = 0 } #Cagliari
province = { id = 563    manpower = 0 } #Bolzano
province = { id = 907    manpower = 0 } #Ancona
province = { id = 1092   manpower = 0 } #Bardiyah
province = { id = 898    manpower = 0 } #Siracusa
province = { id = 902    manpower = 0 } #Potenza
province = { id = 897    manpower = 0 } #Mesina
province = { id = 903    manpower = 0 } #Cosenza
province = { id = 900    manpower = 0 } #Bari
#### Japan
province = { id = 1822   manpower = 2 } #Tokyo
province = { id = 1825   manpower = 2 } #Osaka
province = { id = 1668   manpower = 2 } #Sinuiju
province = { id = 1823   manpower = 2 } #Nagoya
province = { id = 1824   manpower = 2 } #Kanazawa
province = { id = 1681   manpower = 2 } #Kagoshima
province = { id = 1682   manpower = 2 } #Hiroshima
province = { id = 1819   manpower = 1 } #Sendai
province = { id = 1821   manpower = 1 } #Niigata
province = { id = 1683   manpower = 1 } #Kochi
province = { id = 1674   manpower = 1 } #Keijo
province = { id = 1820   manpower = 1 } #Fukushima
province = { id = 1684   manpower = 1 } #Fukuoka
province = { id = 1818   manpower = 1 } #Akita
province = { id = 1834   manpower = 1 } #Sapporo
province = { id = 1562   manpower = 1 } #Jinzhou
province = { id = 1561   manpower = 1 } #Dalian
province = { id = 1624   manpower = 1 } #Zhangjiakou
province = { id = 1716   manpower = 0 } #Taihoku
province = { id = 1558   manpower = 0 } #Mukden
province = { id = 1627   manpower = 0 } #Linxi
province = { id = 1678   manpower = 0 } #Fuzan
province = { id = 1623   manpower = 0 } #Fuxin
province = { id = 1836   manpower = 0 } #Tomari
province = { id = 1675   manpower = 0 } #Taikyu
province = { id = 1673   manpower = 0 } #Shusen
province = { id = 1665   manpower = 0 } #Seishin
province = { id = 1677   manpower = 0 } #Saishu
province = { id = 1556   manpower = 0 } #Qiqihar
province = { id = 1555   manpower = 0 } #Oroqen Zizhiqi
province = { id = 1688   manpower = 0 } #Naha
province = { id = 1676   manpower = 0 } #Koshu
province = { id = 1666   manpower = 0 } #Kanko
province = { id = 1664   manpower = 0 } #Kange
province = { id = 1672   manpower = 0 } #Heijo
province = { id = 1671   manpower = 0 } #Genzan
province = { id = 1833   manpower = 0 } #Asahikawa
#### Latvia
province = { id = 709    manpower = 3 } #Riga
province = { id = 708    manpower = 1 } #Rezeknez
province = { id = 713    manpower = 1 } #Daugavpilsz
province = { id = 712    manpower = 0 } #Liepaja
#### Lithuania
province = { id = 715    manpower = 3 } #Kaunas
province = { id = 714    manpower = 1 } #Siauliai
province = { id = 711    manpower = 1 } #Memel
#### Luxembourg
province = { id = 553    manpower = 1 } #Luxembourg
#### Mexico
province = { id = 244    manpower = 1 } #Mexico City
province = { id = 238    manpower = 0 } #Veracruz
province = { id = 237    manpower = 0 } #Monterrey
province = { id = 197    manpower = 0 } #Hermosillo
province = { id = 200    manpower = 0 } #Culiacan
province = { id = 199    manpower = 0 } #Chihuahua
province = { id = 248    manpower = 0 } #Acapulco
province = { id = 249    manpower = 0 } #Villahermosa
province = { id = 232    manpower = 0 } #Merida
province = { id = 242    manpower = 0 } #Guadalajara
province = { id = 80     manpower = 0 } #Tijuana
province = { id = 243    manpower = 0 } #San Luis Potosi
#### New Zealand
province = { id = 2140   manpower = 1 } #Wellington
province = { id = 2144   manpower = 0 } #Christchurch
province = { id = 2137   manpower = 0 } #Hamilton
province = { id = 2135   manpower = 0 } #Auckland
#### Norway
province = { id = 664    manpower = 1 } #Oslo
province = { id = 674    manpower = 0 } #Trodheim
province = { id = 671    manpower = 0 } #Bergen
province = { id = 662    manpower = 0 } #Stavanger
province = { id = 680    manpower = 0 } #Narvik
province = { id = 663    manpower = 0 } #Kristiansand
province = { id = 668    manpower = 0 } #Hamar
#### Paraguay
province = { id = 366    manpower = 1 } #Asuncion
#### Peru
province = { id = 335    manpower = 1 } #Lima
province = { id = 337    manpower = 0 } #Cuzco
province = { id = 293    manpower = 0 } #Trujillo
province = { id = 338    manpower = 0 } #Arequipal
#### Poland
province = { id = 645    manpower = 2 } # Danzig
province = { id = 643    manpower = 2 } # Warszawa
province = { id = 639    manpower = 2 } # Lodz
province = { id = 638    manpower = 2 } # Krakow
province = { id = 637    manpower = 2 } # Czestochawa
province = { id = 606    manpower = 0 } # Poznan
province = { id = 724    manpower = 0 } # Przemysl
province = { id = 725    manpower = 0 } # Lwow
province = { id = 648    manpower = 0 } # Torun
province = { id = 649    manpower = 0 } # Suwalki
province = { id = 635    manpower = 0 } # Gieszyn
province = { id = 647    manpower = 0 } # Bydgoszcz
#### Portugal
province = { id = 975    manpower = 0 } #Lissaban
province = { id = 964    manpower = 0 } #Portu
province = { id = 974    manpower = 0 } #Portalegre
province = { id = 976    manpower = 0 } #Evora
province = { id = 986    manpower = 0 } #Faro
#### Romania
province = { id = 757    manpower = 2 } #Bucuhuresti
province = { id = 739    manpower = 2 } #Timisoara
province = { id = 760    manpower = 2 } #Ploiesti
province = { id = 761    manpower = 2 } #Constanta
province = { id = 730    manpower = 1 } #Cluj-Napoca H
province = { id = 763    manpower = 1 } #Chisinau R
province = { id = 728    manpower = 0 } #Piatra Neamt
province = { id = 729    manpower = 0 } #Oradea H
province = { id = 868    manpower = 0 } #Dobrich B
province = { id = 629    manpower = 0 } #Arad
province = { id = 731    manpower = 0 } #Sibiu
province = { id = 768    manpower = 0 } #Iasi
province = { id = 736    manpower = 0 } #Craiova
province = { id = 767    manpower = 0 } #Beltsy R
#### Saudi Arabia
province = { id = 1277    manpower = 1 } #Riyadh
#### South Africa
province = { id = 1175   manpower = 1 } #Johannesburg
province = { id = 1172   manpower = 0 } #Durban
province = { id = 1156   manpower = 0 } #Cape Town
province = { id = 1167   manpower = 0 } #Port Elizabeth
province = { id = 1169   manpower = 0 } #East London
province = { id = 1171   manpower = 0 } #Bloemfontein
#### Sweden
province = { id = 2160   manpower = 1 } #Stockholm
province = { id = 653    manpower = 0 } #Malmo
province = { id = 660    manpower = 0 } #Goteborg
province = { id = 661    manpower = 0 } #Norrkoping
province = { id = 691    manpower = 0 } #Orebro
province = { id = 689    manpower = 0 } #Sundsvall
province = { id = 682    manpower = 0 } #Lulea
province = { id = 659    manpower = 0 } #Kalmar
province = { id = 692    manpower = 0 } #Gavle
province = { id = 690    manpower = 0 } #Ostersund
province = { id = 698    manpower = 0 } #Visby
province = { id = 685    manpower = 0 } #Umea
province = { id = 818    manpower = 0 } #Kiruna
province = { id = 665    manpower = 0 } #Karlstad
province = { id = 654    manpower = 0 } #Karlskrana
province = { id = 681    manpower = 0 } #Gallivare
province = { id = 695    manpower = 0 } #Falun
#### Switzerland
province = { id = 564    manpower = 3 } #Zurich
province = { id = 541    manpower = 2 } #Bern
province = { id = 936    manpower = 1 } #Geneve
province = { id = 914    manpower = 1 } #Lausanne
#### Syria
province = { id = 1274   manpower = 1 } #Damascus
province = { id = 1269   manpower = 1 } #Aleppo
province = { id = 1270   manpower = 1 } #Homs
province = { id = 1268   manpower = 1 } #Rawah
#### Turkey
province = { id = 873    manpower = 2 } #Istanbul
province = { id = 1214   manpower = 2 } #Konya
province = { id = 878    manpower = 2 } #Izmir
province = { id = 877    manpower = 2 } #Bursa
province = { id = 1213   manpower = 2 } #Ankara
province = { id = 882    manpower = 0 } #Antalya
province = { id = 1216   manpower = 0 } #Sivas
province = { id = 879    manpower = 0 } #Izmit
province = { id = 1262   manpower = 0 } #Trabzon
province = { id = 1215   manpower = 0 } #Samsun
province = { id = 1210   manpower = 0 } #Mersin
province = { id = 1218   manpower = 0 } #Gaziantep
province = { id = 1266   manpower = 0 } #Van
province = { id = 1217   manpower = 0 } #Kayseri
province = { id = 1263   manpower = 0 } #Kars
province = { id = 881    manpower = 0 } #Eskisehir
province = { id = 1264   manpower = 0 } #Erzurum
province = { id = 1265   manpower = 0 } #Diyanbakir
#### United Kingdom
province = { id = 499    manpower = 1 } #London
province = { id = 497    manpower = 1 } #Birmingham
province = { id = 490    manpower = 1 } #Sheffield
province = { id = 489    manpower = 1 } #Manchester
province = { id = 498    manpower = 1 } #Coventry
province = { id = 502    manpower = 1 } #Southampton
province = { id = 503    manpower = 1 } #Portsmouth
province = { id = 501    manpower = 1 } #Plymouth
province = { id = 1717   manpower = 0 } #Hong Kong
province = { id = 488    manpower = 1 } #Newcastle
province = { id = 486    manpower = 1 } #Glasgow
province = { id = 500    manpower = 0 } #Bristol
province = { id = 1490   manpower = 0 } #Calcutta
province = { id = 1450   manpower = 0 } #Hyberdad
province = { id = 1446   manpower = 0 } #Delhi
province = { id = 1459   manpower = 0 } #Bombay
province = { id = 493    manpower = 0 } #Belfast
province = { id = 487    manpower = 0 } #Edinburgh
province = { id = 491    manpower = 0 } #Cardiff
province = { id = 1498   manpower = 0 } #Patna
province = { id = 1590   manpower = 0 } #Rangoon
province = { id = 485    manpower = 0 } #Perth
province = { id = 1468   manpower = 0 } #Madras
province = { id = 260    manpower = 0 } #Kingston
province = { id = 1417   manpower = 0 } #Karachi
province = { id = 1478   manpower = 0 } #Calicut
province = { id = 484    manpower = 0 } #Aberdeen
province = { id = 1496   manpower = 0 } #Vishakhapatnam
province = { id = 1469   manpower = 0 } #Vijaywada
province = { id = 1599   manpower = 0 } #Taung-Gye
province = { id = 1418   manpower = 0 } #Sukkar
province = { id = 1102   manpower = 0 } #Suez
province = { id = 1438   manpower = 0 } #Srinagar
province = { id = 1766   manpower = 0 } #Singapore
province = { id = 268    manpower = 0 } #Saint Johns
province = { id = 1444   manpower = 0 } #Saharanpur
province = { id = 1435   manpower = 0 } #Rawalpindi
province = { id = 1451   manpower = 0 } #Rajkot
province = { id = 1488   manpower = 0 } #Quetta
province = { id = 1463   manpower = 0 } #Poona
province = { id = 1209   manpower = 0 } #Nicosia
province = { id = 1460   manpower = 0 } #Nagpur
province = { id = 1465   manpower = 0 } #Mangalore
province = { id = 1495   manpower = 0 } #Lucknow
province = { id = 1449   manpower = 0 } #Lahore
province = { id = 1063   manpower = 0 } #Lugos
province = { id = 1765   manpower = 0 } #Kuala Lumpur
province = { id = 272    manpower = 0 } #Kingstown
province = { id = 1442   manpower = 0 } #Jodhpur
province = { id = 1447   manpower = 0 } #Jaipur
province = { id = 1497   manpower = 0 } #Jabalpur
province = { id = 483    manpower = 0 } #Iverness
province = { id = 1464   manpower = 0 } #Huberdad
province = { id = 1499   manpower = 0 } #Gorakhpur
province = { id = 1309   manpower = 0 } #Dar es Salaam
province = { id = 1585   manpower = 0 } #Dacca
province = { id = 1500   manpower = 0 } #Cuttack
province = { id = 1480   manpower = 0 } #Colombo
province = { id = 1445   manpower = 0 } #Cawnpore
province = { id = 1458   manpower = 0 } #Borhampur
province = { id = 1443   manpower = 0 } #Bikaner
province = { id = 1457   manpower = 0 } #Bohpal
province = { id = 1466   manpower = 0 } #Bangalore
province = { id = 1456   manpower = 0 } #Ahmaudabad
#### United States
province = { id = 193   manpower = 1 } #St. Louis
province = { id = 194   manpower = 1 } #Springfield
province = { id = 122   manpower = 1 } #Pittsburgh
province = { id = 177   manpower = 1 } #Philadelphia
province = { id = 181   manpower = 1 } #Norfolk
province = { id = 124   manpower = 1 } #New York
province = { id = 112   manpower = 1 } #Minneapolis
province = { id = 188   manpower = 1 } #Indianapolis
province = { id = 116   manpower = 1 } #Detroit
province = { id = 192   manpower = 0 } #Des Moines
province = { id = 121   manpower = 0 } #Cleveland
province = { id = 187   manpower = 0 } #Chicago
province = { id = 129   manpower = 0 } #Buffalo
province = { id = 178   manpower = 0 } #Washington D.C.
province = { id = 158   manpower = 0 } #San Francisco
province = { id = 184   manpower = 0 } #Nashville
province = { id = 92    manpower = 0 } #Los Angeles
province = { id = 203   manpower = 0 } #Houston
province = { id = 217   manpower = 0 } #Atlanta
province = { id = 106   manpower = 0 } #Seattle
province = { id = 97    manpower = 0 } #Portland
province = { id = 204   manpower = 0 } #New Orleans
province = { id = 211   manpower = 0 } #Mobile
province = { id = 212   manpower = 0 } #Miami
province = { id = 189   manpower = 0 } #Louisville
province = { id = 94    manpower = 0 } #Las Vegas
province = { id = 195   manpower = 0 } #Kansas City
province = { id = 8     manpower = 0 } #Dallas
province = { id = 150   manpower = 0 } #Concord
province = { id = 216   manpower = 0 } #Columbia
province = { id = 183   manpower = 0 } #Charlotte
province = { id = 9     manpower = 0 } #San Antonio
province = { id = 117   manpower = 0 } #Milwaukee
province = { id = 209   manpower = 0 } #Shreveport
province = { id = 91    manpower = 0 } #Salt Lake City
province = { id = 89    manpower = 0 } #Phoenix
province = { id = 191   manpower = 0 } #Omaha
province = { id = 135   manpower = 0 } #Marquette
province = { id = 208   manpower = 0 } #Little Rock
province = { id = 210   manpower = 0 } #Jackson
province = { id = 104   manpower = 0 } #Idaho Falls
province = { id = 105   manpower = 0 } #Great Falls
province = { id = 86    manpower = 0 } #Denver
province = { id = 288   manpower = 0 } #Colon
province = { id = 90    manpower = 0 } #Cheyenne
province = { id = 113   manpower = 0 } #Bismark
province = { id = 87    manpower = 0 } #Albuquerque
province = { id = 196   manpower = 0 } #Tulsa
province = { id = 156   manpower = 0 } #San Bernandino
province = { id = 155   manpower = 0 } #Sacremento
province = { id = 5     manpower = 0 } #Spokane
province = { id = 267   manpower = 0 } #San Juan
province = { id = 114   manpower = 0 } #Rapid City
province = { id = 182   manpower = 0 } #Charleston
province = { id = 125   manpower = 1 } #Boston
#### Uruguay
province = { id = 368    manpower = 1 } #Montevideo
#### Venezuela
province = { id = 282    manpower = 1 } #Maracaibo
province = { id = 278    manpower = 0 } #Cumana
province = { id = 277    manpower = 0 } #Caracas
#### Yugoslavia
province = { id = 738    manpower = 1 } #Beograd
province = { id = 624    manpower = 1 } #Zagreb
province = { id = 745    manpower = 1 } #Sarajevo
province = { id = 743    manpower = 1 } #Split
province = { id = 755    manpower = 1 } #Skopje
province = { id = 569    manpower = 1 } #Rijeka
province = { id = 752    manpower = 1 } #Pristina
province = { id = 570    manpower = 1 } #Ljubljana
province = { id = 746    manpower = 1 } #Kraljevo
province = { id = 747    manpower = 1 } #Dubrovnik
province = { id = 742    manpower = 0 } #Banja Luka
province = { id = 737    manpower = 0 } #Valjevo
province = { id = 740    manpower = 0 } #Osijek
province = { id = 741    manpower = 0 } #Novi Sad
province = { id = 751    manpower = 0 } #Novi Pasar
province = { id = 753    manpower = 0 } #Podgorica

